/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.AdministradorPersistencia;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.asistentes.AsistenteImportacion;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoMensajes;
import ec.gob.sri.dimm.api.ui.editores.InputEditorModeloBase;
import ec.gob.sri.dimm.ats.modelo.excepciones.ExcepcionContribuyenteNoEncontrado;
import ec.gob.sri.dimm.ats.modelo.impl.AdministradorModeloATS;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.InformacionNuevoAnexo;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.Fideicomiso;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.ImportarAnexoPaginaBusqueda;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.ImportarAnexoSeleccionPeriodo;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.NuevoAnexoSeleccionTipo;
import ec.gob.sri.dimm.ats.ui.editores.InputEditorATS;
import ec.gob.sri.dimm.ats.ui.editores.InputEditorErroresInformacionATS;
import ec.gob.sri.dimm.ats.ui.operaciones.OperacionConvertirXSLT;
import ec.gob.sri.dimm.ats.ui.operaciones.OperacionValidacionAnexo;
import ec.gob.sri.dimm.ats.ui.operaciones.OperacionValidacionAnexoAntiguo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.w3c.dom.Document;

public class AsistenteImportarATS
extends AsistenteImportacion<Iva> {
    public static final String ID = "ec.gob.sri.dimm.ats.ui.asistentes.AsistenteImportarATS";
    private Iva modeloIva;
    private InputEditorATS datosInput;
    InformacionNuevoAnexo modeloDatos;
    private NuevoAnexoSeleccionTipo paginaTipo;
    private ImportarAnexoPaginaBusqueda paginaBusqueda;
    private ImportarAnexoSeleccionPeriodo paginaSeleccion;

    public AsistenteImportarATS() {
        super("Anexo Transaccional", "ec.gob.sri.dimm.ats.ui.editores.EditorATS");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.modeloDatos = new InformacionNuevoAnexo();
        this.paginaTipo = new NuevoAnexoSeleccionTipo();
        this.paginaTipo.setModeloDatos(this.modeloDatos);
        this.paginaSeleccion = new ImportarAnexoSeleccionPeriodo(true);
        this.paginaBusqueda = new ImportarAnexoPaginaBusqueda(true);
        this.addPage((IWizardPage)this.paginaTipo);
        this.addPage((IWizardPage)this.paginaSeleccion);
        this.addPage((IWizardPage)this.paginaBusqueda);
    }

    protected File getArchivoXML() {
        String rutaTemporalXML = AdministradorPersistencia.generarRutaArchivoXMLTemporal();
        File resultFile = new File(rutaTemporalXML);
        OperacionConvertirXSLT conversion = null;
        boolean validacionEsquemaExitosa = true;
        File archivoXML = this.paginaBusqueda.getArchivoXML();
        switch (this.paginaSeleccion.getTipo()) {
            case ARCHIVO_ACTUAL_DESDE_JUN_2020: {
                return archivoXML;
            }
            case EXCEL: {
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/excelToAts.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/fixExcel.xsl");
                conversion = new OperacionConvertirXSLT(this.paginaBusqueda.getArchivoXML(), resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error importando anexo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de importaci\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de importaci\u00f3n. Consulte el archivo de errores");
                    return null;
                }
            }
            case ARCHIVO_VIGENTE_HASTA_DIC_2007: {
                validacionEsquemaExitosa = this.validarEsquema(validacionEsquemaExitosa, "/ec/gob/sri/dimm/ats/validacion/esquema/xsd/at_2007.xsd");
                if (!validacionEsquemaExitosa) break;
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2at.xslt");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2013.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2015.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_2019_hasta_may_2020.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_desde_jun_2020.xsl");
                conversion = new OperacionConvertirXSLT(archivoXML, resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error importando anexo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de validaci\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de validaci\u00f3n. Consulte el archivo de errores");
                    return null;
                }
            }
            case ARCHIVO_VIGENTE_DESDE_ENE_2008_A_DIC_2012: {
                validacionEsquemaExitosa = this.validarEsquema(validacionEsquemaExitosa, "/ec/gob/sri/dimm/ats/validacion/esquema/xsd/at_2012.xsd");
                if (!validacionEsquemaExitosa) break;
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2013.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2015.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_2019_hasta_may_2020.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_desde_jun_2020.xsl");
                conversion = new OperacionConvertirXSLT(archivoXML, resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error importando anexo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de conversi\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
                    return null;
                }
            }
            case ARCHIVO_VIGENTE_DESDE_ENE_2013_A_FEB_2015: {
                validacionEsquemaExitosa = this.validarEsquema(validacionEsquemaExitosa, "/ec/gob/sri/dimm/ats/validacion/esquema/xsd/at_ene_2013_feb_2015.xsd");
                if (!validacionEsquemaExitosa) break;
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2015.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_2019_hasta_may_2020.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_desde_jun_2020.xsl");
                conversion = new OperacionConvertirXSLT(this.paginaBusqueda.getArchivoXML(), resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de conversi\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
                    return null;
                }
            }
            case ARCHIVO_VIGENTE_DESDE_MAR_2015_A_ABR_2016: {
                validacionEsquemaExitosa = this.validarEsquema(validacionEsquemaExitosa, "/ec/gob/sri/dimm/ats/validacion/esquema/xsd/at_mar_2015_abr_2016.xsd");
                if (!validacionEsquemaExitosa) break;
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_2019_hasta_may_2020.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_desde_jun_2020.xsl");
                conversion = new OperacionConvertirXSLT(this.paginaBusqueda.getArchivoXML(), resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de conversi\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
                    return null;
                }
            }
            case ARCHIVO_VIGENTE_DESDE_MAY_2016_A_MAY_2020: {
                validacionEsquemaExitosa = this.validarEsquema(validacionEsquemaExitosa, "/ec/gob/sri/dimm/ats/validacion/esquema/xsd/at_may_2016_may_2020.xsd");
                if (!validacionEsquemaExitosa) break;
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_desde_jun_2020.xsl");
                conversion = new OperacionConvertirXSLT(this.paginaBusqueda.getArchivoXML(), resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error validando anexo externo...", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de conversi\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores...");
                    return null;
                }
            }
        }
        return null;
    }

    private boolean validarEsquema(boolean validacionEsquemaExitosa, String esquema) {
        OperacionValidacionAnexoAntiguo operacionValidacion = new OperacionValidacionAnexoAntiguo(this.paginaBusqueda.getArchivoXML(), esquema);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)operacionValidacion);
        }
        catch (InvocationTargetException e) {
            PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
            Throwable cause = e.getCause();
            this.verificarErrores(cause);
            return false;
        }
        catch (InterruptedException e) {
            PluginLogger.logError((String)"Se ha interrumpido el proceso de validaci\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
            this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
            return false;
        }
        ResultadoValidacion resultadoEsquema = operacionValidacion.getResultadoValidacionEsquema();
        if (resultadoEsquema != null && (resultadoEsquema.tieneVariosErrores() || resultadoEsquema.tieneVariasAdvertencias())) {
            DialogoMensajes mensajesEsquema = new DialogoMensajes(this.getShell(), "Anexo Transaccional", resultadoEsquema.getMensajes());
            mensajesEsquema.open();
            validacionEsquemaExitosa = false;
        }
        return validacionEsquemaExitosa;
    }

    private void verificarErrores(Throwable cause) {
        if (cause == null) {
            this.mostrarError("Se ha producido un error inesperado al convertir el anexo.");
        } else if (cause instanceof OutOfMemoryError) {
            this.mostrarError("Estimado Contribuyente, para convertir archivos superiores a 15MB seguir la gu\u00eda del manual de usuario.");
        } else if (cause instanceof NullPointerException) {
            this.mostrarError("Estimado Contribuyente, el archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo. ");
        } else if (cause instanceof IOException) {
            this.mostrarError("Estimado Contribuyente, no hay espacio en disco suficiente o no existen permisos para crear el archivo XML");
        } else {
            this.mostrarError("Estimado Contribuyente, el archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo.. ");
        }
    }

    protected boolean validarAnexo(File archivoAnexo) {
        File archivoErroresValidacion;
        OperacionValidacionAnexo operacionValidacion = new OperacionValidacionAnexo(archivoAnexo);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)operacionValidacion);
        }
        catch (InvocationTargetException e1) {
            PluginLogger.logError((String)"Error validando anexo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
            Throwable cause = e1.getCause();
            if (cause == null) {
                this.mostrarError("Se ha producido un error inesperado al validar el anexo.");
            } else if (cause instanceof OutOfMemoryError) {
                this.mostrarError("Estimado Contribuyente, para convertir archivos superiores a 15MB seguir la gu\u00eda del manual de usuario.");
            } else if (cause instanceof NullPointerException) {
                this.mostrarError("Estimado Contribuyente, el archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo. ");
            } else if (cause instanceof IOException) {
                this.mostrarError("Estimado Contribuyente, no hay espacio en disco suficiente o no existen permisos para crear el archivo XML");
            } else {
                this.mostrarError("Estimado Contribuyente, el archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo.. ");
            }
            return false;
        }
        catch (InterruptedException e1) {
            PluginLogger.logError((String)"Se ha interrumpido el proceso de validaci\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
            this.mostrarError("Se ha interrumpido el proceso de validaci\u00f3n. Consulte el archivo de errores");
            return false;
        }
        boolean validacionExitosa = true;
        ResultadoValidacion resultadoEsquema = operacionValidacion.getResultadoValidacionEsquema();
        if (resultadoEsquema != null && (resultadoEsquema.tieneVariosErrores() || resultadoEsquema.tieneVariasAdvertencias())) {
            DialogoMensajes mensajesEsquema = new DialogoMensajes(this.getShell(), "Anexo Transaccional", resultadoEsquema.getMensajes());
            mensajesEsquema.open();
            validacionExitosa = false;
        }
        if (validacionExitosa && (archivoErroresValidacion = operacionValidacion.getArchivoErroresInformacion()) != null) {
            InputEditorErroresInformacionATS datosInput = new InputEditorErroresInformacionATS(archivoErroresValidacion, archivoAnexo);
            try {
                this.getActivePage().openEditor((IEditorInput)datosInput, "ec.gob.sri.dimm.ats.ui.editores.EditorErroresInformacionATS");
            }
            catch (PartInitException e) {
                this.mostrarError("Se ha producido un problema al abrir el visor de errores de validaci\u00f3n: ");
                PluginLogger.logError((String)"Error al mostrar errores de validacion de informacion", (String)"ec.gob.sri.dimm.ats.ui", (Exception)((Object)e));
            }
            if (operacionValidacion.isTieneErrores()) {
                validacionExitosa = false;
            }
        }
        if (!validacionExitosa) {
            this.mostrarError(String.format("Se han producido errores al validar el anexo que est\u00e1 siendo importado.%n%nRevise los detalles de errores para obtener m\u00e1s informaci\u00f3n.", new Object[0]));
        }
        return validacionExitosa;
    }

    protected Iva obtenerModelo(final Document documentoAnexo) {
        IRunnableWithProgress operacionImportarAnexo = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AdministradorModeloATS administradorModelo = new AdministradorModeloATS();
                try {
                    AsistenteImportarATS.this.modeloIva = administradorModelo.importar(documentoAnexo);
                    AsistenteImportarATS.this.modeloIva.getDatosDeclaracion().setTipoDeclaracion(AsistenteImportarATS.this.modeloDatos.getDatosInformante().getTipoDeclaracion());
                }
                catch (ExcepcionContribuyenteNoEncontrado e) {
                    PluginLogger.logError((String)"Contribuyente no existe. Debe ser registrado", (String)"ec.gob.sri.dimm.ats.ui", (Exception)((Object)e));
                    throw new InterruptedException(String.format("El informante del anexo que est\u00e1 intentando importar no se encuentra registrado.%n%nReg\u00edstrelo utilizando la opci\u00f3n de creaci\u00f3n de RUC [Archivo | Nuevo | RUC] e intente importar el anexo nuevamente.", new Object[0]));
                }
            }
        };
        try {
            this.getContainer().run(true, false, operacionImportarAnexo);
            return this.modeloIva;
        }
        catch (InvocationTargetException e) {
            PluginLogger.logError((String)"Error importando anexo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
            Throwable cause = e.getCause();
            if (cause == null) {
                this.mostrarError("Se ha producido un error inesperado al importar el anexo.");
            } else if (cause instanceof OutOfMemoryError) {
                this.mostrarError("Estimado Contribuyente, para convertir archivos superiores a 15MB seguir la gu\u00eda del manual de usuario.");
            } else if (cause instanceof NullPointerException) {
                this.mostrarError("Estimado Contribuyente, el archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo. ");
            } else if (cause instanceof IOException) {
                this.mostrarError("Estimado Contribuyente, no hay espacio en disco suficiente o no existen permisos para crear el archivo XML");
            } else if (cause instanceof RuntimeException) {
                this.mostrarError(cause.getMessage());
            } else {
                this.mostrarError("Estimado Contribuyente, el archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo.. ");
            }
        }
        catch (InterruptedException e) {
            this.mostrarError(e.getMessage());
        }
        return null;
    }

    protected InputEditorModeloBase<Iva> obtenerInputEditor(Iva modeloImportado) {
        this.datosInput = new InputEditorATS(modeloImportado.getIdentificacion(), modeloImportado.getDatosDeclaracion().getAnio(), modeloImportado.getDatosDeclaracion().getMes(), modeloImportado.getRazonSocial(), modeloImportado.getDatosDeclaracion().getTipoDeclaracion());
        this.datosInput.setModeloDatos((RaizModelo)modeloImportado);
        for (Fideicomiso fideicomiso : modeloImportado.getFideicomisos()) {
            if (!fideicomiso.isFideicomisoRepetido()) continue;
            this.mostrarAdvertencia("Se ha encontrado tipos de Fideicomisos Repetidos: " + fideicomiso.getDescripcionTipoFideicomiso() + " para un mismo RUC: " + fideicomiso.getRucFideicomiso() + " favor revisar la informaci\u00f3n importada en esta secci\u00f3n.");
        }
        return this.datosInput;
    }
}

